/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.SimpleDialog;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;

public class TextDialog
extends SimpleDialog {
    private static final int WINDOW_WIDTH = 500;
    private TextInput input = null;
    private Object value = null;

    public TextDialog(int position) {
        super(position);
        this.setSize(500, -1);
        this.setSideImage(SWTUtil.getImage("dialog-question-large.png"));
        this.input = new TextInput("");
        this.input.setName(Application.getI18n().tr("Ihre Eingabe"));
    }

    public void setLabelText(String t) {
        if (StringUtils.trimToNull((String)t) != null) {
            this.input.setName(t);
        }
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        String text = this.getText();
        if (StringUtils.trimToNull((String)text) != null) {
            c.addText(text, true);
        }
        c.addInput(this.input);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(Application.getI18n().tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                TextDialog.this.value = TextDialog.this.input.getValue();
                TextDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(new Cancel());
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
    }

    @Override
    protected Object getData() throws Exception {
        return this.value;
    }
}

